﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports System.Runtime.InteropServices
Imports System.IO.Ports
Imports System.Text.RegularExpressions
Imports VB_ZPL.Printer
Public Class ZPL_Demo
    Private printer As DemoPrinter = New DemoPrinter()
    Dim iResult As Integer = 0



    Private Sub Button1_Click(sender As Object, e As EventArgs) Handles Button1.Click
        iResult = printer.DemoPrinterCreator("TE200")
        Dim preadedNum As Integer = 0
        Dim strrfid As Byte() = New Byte(8) {}
        If Constants.E_SUCCESS = iResult Then
            iResult = printer.DemoPortOpen("USB")
            If Constants.E_SUCCESS = iResult Then
                '开始
                iResult = printer.DemoStartFormat()

                '获取版本号
                Dim bVersion As Byte() = New Byte(20) {}
                iResult = printer.DemoGetPrinterFirmwareVersion(bVersion)
                Dim myString As String = Encoding.Default.GetString(bVersion)
                Console.WriteLine("version: " & myString)

                '设置打印浓度
                iResult = printer.DemoSetPrintDarkness(20)

                '设置打印宽度
                iResult = printer.DemoSetPrintWidth(576)

                '设置是否翻转打印
                iResult = printer.DemoSetPrintOrientation(0)

                '打印图片
                iResult = printer.DemoPrintImage(100, 100, "D:\\1.bmp")

                '打印Pdf417
                iResult = printer.DemoPdf417(100, 250, 0, 2, 20, 2, 5, 5, "N", "0010101101")

                '打印BarCode39条码
                iResult = printer.DemoBarCode39(100, 400, 0, 3, 50, "Y", "Y", "Y", "0123456")

                '打印CodeEan8条码
                iResult = printer.DemoCodeEan8(100, 500, 0, 3, 60, "Y", "Y", "90381010")

                '打印UPC-A
                iResult = printer.DemoUpcaBarcode(100, 600, 0, 3, 50, "Y", "Y", "N", "47631664454")

                '打印UPC扩展条码
                iResult = printer.DemoUpcExtensions(100, 700, 0, 3, 50, "Y", "Y", "01234")

                '打印二维码
                iResult = printer.DemoQRCode(100, 800, 0, 1, 3, "M", "M", "N", "1000000001")

                '打印
                iResult = printer.DemoSetChangeFontEncoding(14)
                iResult = printer.DemoText(100, 900, 16, 0, 40, 40, "你好")
                iResult = printer.DemoText(300, 900, 16, 0, 40, 40, "hello")
                iResult = printer.DemoText(500, 900, 16, 0, 40, 40, "こんにちは")

                '绘制图形圆圈
                iResult = printer.DemoGraphicCircle(100, 1000, 150, 5)

                '打印椭圆
                iResult = printer.DemoGraphicEllipse(300, 1000, 150, 100, 10)

                '打印对角线
                iResult = printer.DemoGraphicDiagonalLine(500, 1000, &H52, 50, 50, 20)

                '绘制图形框
                iResult = printer.DemoGraphicBox(100, 1200, 100, 100, 60, 3)

                '打印符号
                iResult = printer.DemoGraphicSymbol(300, 1200, 0, 200, 200, "A")

                'RFID读写
                'iResult = printer.DemoRfidWrite("H", 2, 4, "1", "12345678")
                'iResult = printer.DemoRfidRead("H", 2, 4, "1", "", "")

                'RFID空任务
                'iResult = printer.DemoRfidReadEmpty()

                'ZPL切刀命令
                '设置是否切刀、剥离等
                iResult = printer.DemoSetPrintMode("C", "Y")
                iResult = printer.DemoCutter(0)
                iResult = printer.DemoSetPrintQuantity(1, 1, 1, "N")

                '结束
                iResult = printer.DemoEndFormat()

                'iResult = printer.DemoReadData(strrfid, strrfid.Length, preadedNum)

                '关闭端口
                iResult = printer.DemoPortClose()

                '销毁
                iResult = printer.DemoPrinterDestroy()
            Else
                MessageBox.Show("Usb Device not found.")
                Close()
            End If
        Else
            MessageBox.Show("Printer Device not found.")
            Close()
        End If

        'RFIDTEXT_HL()
        'RFIDTEXT_HR()
        'RFIDTEXT_RB()
        'RFIDTEXT_RR()
        'RFIDTEXT_RS()
        'RFIDTEXT_RW()
        'RFIDTEXT_RZ()
        'RFIDTEXT_RU()
    End Sub

    Private Sub RFIDTEXT_HL()
        iResult = printer.DemoPrinterCreator("HT300")
        If Constants.E_SUCCESS = iResult Then
            iResult = printer.DemoPortOpen("USB")
            If Constants.E_SUCCESS = iResult Then
                '开始
                iResult = printer.DemoStartFormat()

                iResult = printer.DemoRfidReturnHostDatalog()
                '结束
                iResult = printer.DemoEndFormat()

                '关闭端口
                iResult = printer.DemoPortClose()

                '销毁
                iResult = printer.DemoPrinterDestroy()
            Else
                MessageBox.Show("Usb Device not found.")
                Close()
            End If
        Else
            MessageBox.Show("Printer Device not found.")
            Close()
        End If
    End Sub

    Private Sub RFIDTEXT_HR()
        Dim pStartStr As String = "start"
        Dim pEndStr As String = "end"
        Dim pStartPosition As String = "B20"
        Dim pEndPosition As String = "F42"
        Dim model = "M"
        iResult = printer.DemoPrinterCreator("HT300")
        If Constants.E_SUCCESS = iResult Then
            iResult = printer.DemoPortOpen("USB")
            If Constants.E_SUCCESS = iResult Then
                '开始
                iResult = printer.DemoStartFormat()

                iResult = printer.DemoRfidCorrectXpdnrPosition(pStartStr, pEndStr, pStartPosition, pEndPosition, model)
                '结束
                iResult = printer.DemoEndFormat()

                '关闭端口
                iResult = printer.DemoPortClose()

                '销毁
                iResult = printer.DemoPrinterDestroy()
            Else
                MessageBox.Show("Usb Device not found.")
                Close()
            End If
        Else
            MessageBox.Show("Printer Device not found.")
            Close()
        End If
    End Sub

    Private Sub RFIDTEXT_RB()
        Dim nTotalNum As Integer = 96
        Dim pPartitionSize(5) As Integer
        pPartitionSize(0) = 8
        pPartitionSize(1) = 3
        pPartitionSize(2) = 3
        pPartitionSize(3) = 20
        pPartitionSize(4) = 24
        pPartitionSize(5) = 38
        Dim pStartPosition As String = "B20"
        Dim pEndPosition As String = "F42"
        Dim model As Char = "M"
        iResult = printer.DemoPrinterCreator("HT300")
        If Constants.E_SUCCESS = iResult Then
            iResult = printer.DemoPortOpen("USB")
            If Constants.E_SUCCESS = iResult Then
                '开始
                iResult = printer.DemoStartFormat()

                iResult = printer.DemoRfidDefineDataStruct(nTotalNum, pPartitionSize, UBound(pPartitionSize) - LBound(pPartitionSize) + 1)

                iResult = printer.DemoRfidWrite("E", 0, 1, "E", "48,1,6,770289,10001025,1")
                '结束
                iResult = printer.DemoEndFormat()

                '关闭端口
                iResult = printer.DemoPortClose()

                '销毁
                iResult = printer.DemoPrinterDestroy()
            Else
                MessageBox.Show("Usb Device not found.")
                Close()
            End If
        Else
            MessageBox.Show("Printer Device not found.")
            Close()
        End If
    End Sub

    Private Sub RFIDTEXT_RR()
        Dim nRetryCount As Integer = 2
        iResult = printer.DemoPrinterCreator("HT300")
        If Constants.E_SUCCESS = iResult Then
            iResult = printer.DemoPortOpen("USB")
            If Constants.E_SUCCESS = iResult Then
                '开始
                iResult = printer.DemoStartFormat()

                iResult = printer.DemoRfidRetryCount(nRetryCount)

                iResult = printer.DemoRfidWrite("H", 0, 1, "E", "1234")
                '结束
                iResult = printer.DemoEndFormat()

                '关闭端口
                iResult = printer.DemoPortClose()

                '销毁
                iResult = printer.DemoPrinterDestroy()
            Else
                MessageBox.Show("Usb Device not found.")
                Close()
            End If
        Else
            MessageBox.Show("Printer Device not found.")
            Close()
        End If
    End Sub

    Private Sub RFIDTEXT_RS()
        Dim nTagNum As Integer = 2
        Dim nErrorAct As Integer = 80
        iResult = printer.DemoPrinterCreator("HT300")
        If Constants.E_SUCCESS = iResult Then
            iResult = printer.DemoPortOpen("USB")
            If Constants.E_SUCCESS = iResult Then
                '开始
                iResult = printer.DemoStartFormat()

                iResult = printer.DemoRfidSetParameters(nTagNum, nErrorAct)
                '结束
                iResult = printer.DemoEndFormat()

                '关闭端口
                iResult = printer.DemoPortClose()

                '销毁
                iResult = printer.DemoPrinterDestroy()
            Else
                MessageBox.Show("Usb Device not found.")
                Close()
            End If
        Else
            MessageBox.Show("Printer Device not found.")
            Close()
        End If
    End Sub

    Private Sub RFIDTEXT_RW()
        Dim nReadPower = 72 'H
        Dim nWritePower = 72 'H
        Dim nAntennaType As Integer = 1
        iResult = printer.DemoPrinterCreator("HT300")
        If Constants.E_SUCCESS = iResult Then
            iResult = printer.DemoPortOpen("USB")
            If Constants.E_SUCCESS = iResult Then
                '开始
                'iResult = printer.DemoStartFormat()

                iResult = printer.DemoRfidSetPowerLevel(nReadPower, nWritePower, nAntennaType)

                '结束
                'iResult = printer.DemoEndFormat()

                '关闭端口
                iResult = printer.DemoPortClose()

                '销毁
                iResult = printer.DemoPrinterDestroy()
            Else
                MessageBox.Show("Usb Device not found.")
                Close()
            End If
        Else
            MessageBox.Show("Printer Device not found.")
            Close()
        End If
    End Sub

    Private Sub RFIDTEXT_RZ()
        Dim password As String = "1234ABCD"
        Dim nMemoryBlock As Integer = 69 'E
        Dim locktype As Char = "L"
        iResult = printer.DemoPrinterCreator("HT300")
        If Constants.E_SUCCESS = iResult Then
            iResult = printer.DemoPortOpen("USB")
            If Constants.E_SUCCESS = iResult Then
                '开始
                iResult = printer.DemoStartFormat()

                iResult = printer.DemoRfidWrite("H", 0, 1, "E", "112233445566778899001122")

                iResult = printer.DemoRfidSetLockTagAndPassword(password, nMemoryBlock, locktype)
                '结束
                iResult = printer.DemoEndFormat()

                '关闭端口
                iResult = printer.DemoPortClose()

                '销毁
                iResult = printer.DemoPrinterDestroy()
            Else
                MessageBox.Show("Usb Device not found.")
                Close()
            End If
        Else
            MessageBox.Show("Printer Device not found.")
            Close()
        End If
    End Sub

    Private Sub RFIDTEXT_RU()
        iResult = printer.DemoPrinterCreator("HT300")
        If Constants.E_SUCCESS = iResult Then
            iResult = printer.DemoPortOpen("USB")
            If Constants.E_SUCCESS = iResult Then
                '开始
                iResult = printer.DemoStartFormat()

                iResult = printer.DemoRfidReadChipSerialization()

                iResult = printer.DemoScalableFontText(10, 10, "0", 78, 50, 50, "Serial Number: #H")

                iResult = printer.DemoRfidWrite("H", 0, 1, "E", "12#H")
                '结束
                iResult = printer.DemoEndFormat()

                '关闭端口
                iResult = printer.DemoPortClose()

                '销毁
                iResult = printer.DemoPrinterDestroy()
            Else
                MessageBox.Show("Usb Device not found.")
                Close()
            End If
        Else
            MessageBox.Show("Printer Device not found.")
            Close()
        End If
    End Sub

End Class
